/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.ldtteam.blockout.Pane;
import com.ldtteam.blockout.PaneBuilders;
import com.ldtteam.blockout.controls.AbstractTextBuilder;
import com.ldtteam.blockout.controls.Button;
import com.ldtteam.blockout.controls.Text;
import com.ldtteam.blockout.views.ScrollingList;
import com.ldtteam.structurize.util.LanguageHandler;
import com.minecolonies.api.colony.ICitizen;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.HiringMode;
import com.minecolonies.api.colony.buildings.IBuildingCanBeHiredFrom;
import com.minecolonies.api.entity.citizen.Skill;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.client.gui.AbstractWindowSkeleton;
import com.minecolonies.coremod.colony.CitizenDataView;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingWorkerView;
import com.minecolonies.coremod.network.messages.server.colony.building.HireFireMessage;
import com.minecolonies.coremod.network.messages.server.colony.citizen.PauseCitizenMessage;
import com.minecolonies.coremod.network.messages.server.colony.citizen.RestartCitizenMessage;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import org.jetbrains.annotations.NotNull;

public class WindowHireWorker
extends AbstractWindowSkeleton {
    protected final AbstractBuildingWorkerView building;
    protected final IColonyView colony;
    protected List<ICitizenDataView> citizens = new ArrayList<ICitizenDataView>();
    protected final ScrollingList citizenList;

    public WindowHireWorker(IColonyView c, BlockPos buildingId) {
        super("minecolonies:gui/windowhireworker.xml");
        this.colony = c;
        this.building = (AbstractBuildingWorkerView)this.colony.getBuilding(buildingId);
        this.citizenList = (ScrollingList)this.findPaneOfTypeByID("unemployed", ScrollingList.class);
        super.registerButton("cancel", this::cancelClicked);
        super.registerButton("done", this::doneClicked);
        super.registerButton("fire", this::fireClicked);
        super.registerButton("pause", this::pauseClicked);
        super.registerButton("restart", this::restartClicked);
        super.registerButton("mode", this::modeClicked);
        this.setupSettings((Button)this.findPaneOfTypeByID("mode", Button.class));
    }

    private void cancelClicked(@NotNull Button button) {
        if (button.getID().equals("cancel") && this.colony.getTownHall() != null) {
            this.building.openGui(false);
        }
    }

    private void modeClicked(@NotNull Button button) {
        this.switchHiringMode(button);
    }

    private void switchHiringMode(Button settingsButton) {
        int index = this.building.getHiringMode().ordinal() + 1;
        if (index >= HiringMode.values().length) {
            index = 0;
        }
        this.building.setHiringMode(HiringMode.values()[index]);
        this.setupSettings(settingsButton);
    }

    private void setupSettings(Button settingsButton) {
        settingsButton.setText(LanguageHandler.format((String)("com.minecolonies.coremod.gui.hiringmode." + this.building.getHiringMode().name().toLowerCase(Locale.ENGLISH)), (Object[])new Object[0]));
    }

    private void restartClicked(@NotNull Button button) {
        int row = this.citizenList.getListElementIndexByPane((Pane)button);
        int id = this.citizens.toArray(new CitizenDataView[0])[row].getId();
        Network.getNetwork().sendToServer(new RestartCitizenMessage(this.building, id));
        this.close();
    }

    private void pauseClicked(@NotNull Button button) {
        int row = this.citizenList.getListElementIndexByPane((Pane)button);
        int id = this.citizens.toArray(new CitizenDataView[0])[row].getId();
        ICitizenDataView citizen = this.citizens.get(row);
        Network.getNetwork().sendToServer(new PauseCitizenMessage(this.building, id));
        citizen.setPaused(!citizen.isPaused());
    }

    private void fireClicked(@NotNull Button button) {
        int row = this.citizenList.getListElementIndexByPane((Pane)button);
        int id = this.citizens.toArray(new CitizenDataView[0])[row].getId();
        ICitizenDataView citizen = this.citizens.get(row);
        Network.getNetwork().sendToServer(new HireFireMessage(this.building, false, id));
        this.building.removeWorkerId(id);
        citizen.setWorkBuilding(null);
        this.onOpened();
    }

    private void doneClicked(@NotNull Button button) {
        int row = this.citizenList.getListElementIndexByPane((Pane)button);
        int id = this.citizens.get(row).getId();
        ICitizenDataView citizen = this.citizens.get(row);
        this.building.addWorkerId(id);
        Network.getNetwork().sendToServer(new HireFireMessage(this.building, true, id));
        citizen.setWorkBuilding(this.building.getPosition());
        this.onOpened();
    }

    protected void updateCitizens() {
        this.citizens.clear();
        this.citizens = this.colony.getCitizens().values().stream().filter(citizen -> !citizen.isChild()).filter(citizen -> citizen.getWorkBuilding() == null || this.building.getPosition().equals((Object)citizen.getWorkBuilding()) || this.colony.getBuilding(citizen.getWorkBuilding()) instanceof IBuildingCanBeHiredFrom).sorted(Comparator.comparing(ICitizen::getName)).collect(Collectors.toList());
        this.citizens.sort((c1, c2) -> {
            int i1 = this.building.getPosition().equals((Object)c1.getWorkBuilding()) ? -1 : 0;
            int i2 = this.building.getPosition().equals((Object)c2.getWorkBuilding()) ? -1 : 0;
            return Integer.compare(i1, i2);
        });
    }

    public void onOpened() {
        this.updateCitizens();
        ((Text)this.findPaneOfTypeByID("autoHireWarn", Text.class)).off();
        this.citizenList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return WindowHireWorker.this.citizens.size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                ICitizenDataView citizen = WindowHireWorker.this.citizens.get(index);
                Skill primary = WindowHireWorker.this.building.getPrimarySkill();
                Skill secondary = WindowHireWorker.this.building.getSecondarySkill();
                Button isPaused = (Button)rowPane.findPaneOfTypeByID("pause", Button.class);
                if ((citizen.getWorkBuilding() == null || WindowHireWorker.this.colony.getBuilding(citizen.getWorkBuilding()) instanceof IBuildingCanBeHiredFrom) && WindowHireWorker.this.building.canAssign(citizen) && WindowHireWorker.this.building.getWorkerId().size() < WindowHireWorker.this.building.getMaxInhabitants() && !WindowHireWorker.this.building.getWorkerId().contains(citizen.getId())) {
                    ((Button)rowPane.findPaneOfTypeByID("fire", Button.class)).off();
                    ((Button)rowPane.findPaneOfTypeByID("done", Button.class)).on();
                    isPaused.off();
                    ((Button)rowPane.findPaneOfTypeByID("restart", Button.class)).off();
                } else if (WindowHireWorker.this.building.getWorkerId().size() >= WindowHireWorker.this.building.getMaxInhabitants() && !WindowHireWorker.this.building.getWorkerId().contains(citizen.getId())) {
                    ((Button)rowPane.findPaneOfTypeByID("fire", Button.class)).off();
                    ((Button)rowPane.findPaneOfTypeByID("done", Button.class)).off();
                    isPaused.off();
                    ((Button)rowPane.findPaneOfTypeByID("restart", Button.class)).off();
                } else {
                    ((Button)rowPane.findPaneOfTypeByID("done", Button.class)).off();
                    ((Button)rowPane.findPaneOfTypeByID("fire", Button.class)).on();
                    if (!WindowHireWorker.this.building.getColony().isManualHiring() && WindowHireWorker.this.building.getHiringMode() == HiringMode.DEFAULT || WindowHireWorker.this.building.getHiringMode() == HiringMode.AUTO) {
                        ((Button)rowPane.findPaneOfTypeByID("fire", Button.class)).disable();
                        ((Text)WindowHireWorker.this.findPaneOfTypeByID("autoHireWarn", Text.class)).on();
                    }
                    isPaused.on();
                    isPaused.setText(LanguageHandler.format((String)(citizen.isPaused() ? "com.minecolonies.coremod.gui.hiring.buttonunpaused" : "com.minecolonies.coremod.gui.hiring.buttonpaused"), (Object[])new Object[0]));
                }
                if (citizen.isPaused()) {
                    ((Button)rowPane.findPaneOfTypeByID("restart", Button.class)).on();
                } else {
                    ((Button)rowPane.findPaneOfTypeByID("restart", Button.class)).off();
                }
                StringTextComponent intermString = new StringTextComponent(" ");
                AbstractTextBuilder.TextBuilder textBuilder = PaneBuilders.textBuilder();
                textBuilder.append((IFormattableTextComponent)new StringTextComponent(""));
                int skillCount = citizen.getCitizenSkillHandler().getSkills().entrySet().size();
                for (Map.Entry<Skill, Tuple<Integer, Double>> entry : citizen.getCitizenSkillHandler().getSkills().entrySet()) {
                    String skillName = entry.getKey().name().toLowerCase(Locale.US);
                    int skillLevel = (Integer)entry.getValue().func_76341_a();
                    Style skillStyle = WindowHireWorker.this.createColor(primary, secondary, entry.getKey());
                    textBuilder.append(new TranslationTextComponent("com.minecolonies.coremod.gui.citizen.skills." + skillName).func_230530_a_(skillStyle));
                    textBuilder.append(new StringTextComponent(": " + skillLevel).func_230530_a_(skillStyle));
                    if (--skillCount <= 0) continue;
                    textBuilder.append((IFormattableTextComponent)intermString);
                }
                textBuilder.newLine();
                ((Text)rowPane.findPaneOfTypeByID("citizen", Text.class)).setText((citizen.getJob().isEmpty() ? "" : LanguageHandler.format((String)citizen.getJob(), (Object[])new Object[0]) + ": ") + citizen.getName());
                ((Text)rowPane.findPaneOfTypeByID("attributes", Text.class)).setText(textBuilder.getText());
            }
        });
    }

    protected Style createColor(Skill primary, Skill secondary, Skill current) {
        if (primary == current) {
            return Style.field_240709_b_.func_240721_b_(TextFormatting.GREEN).func_240721_b_(TextFormatting.BOLD);
        }
        if (secondary == current) {
            return Style.field_240709_b_.func_240721_b_(TextFormatting.YELLOW).func_240721_b_(TextFormatting.ITALIC);
        }
        return Style.field_240709_b_;
    }
}

